function [chi2_pv,chi2_val, chi2_st] = chi2(A)
    A = A - diag(diag(A));
    [n,~] = size(A);
    V = ones(1,n) * A * ones(n,1);
    
    alpha_hat = (n*(n-1))^(-1)*V;

    A_check = A - alpha_hat*ones(n,1)*ones(n,1)';
    
    chi2_1 = ones(n, 1)'*A_check^2*ones(n,1); 
    chi2_2 = - diag(A_check)'*A_check*ones(n,1);
    chi2_3 = - ones(n,1)'*(A_check.*A_check)*ones(n,1);
    chi2_4 = 2*sum( diag(A_check.*A_check) );
    chi2_5 = - ones(n,1)'*A_check*diag(A_check);
    
    chi2_val = chi2_1 + chi2_2 + chi2_3 + chi2_4 + chi2_5; 

    chi2_st = chi2_val/((n-1)*alpha_hat*(1-alpha_hat)*sqrt(2*n));

    chi2_pv = 1 - normcdf(chi2_st);
end 